/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.entity;

import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.mojang.authlib.GameProfile;
import java.util.List;
import morph.avaritia.Avaritia;
import morph.avaritia.entity.EndestPearlEntity;
import morph.avaritia.init.AvaritiaModContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class GapingVoidEntity
extends Entity {
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(GapingVoidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int MAX_LIFETIME = 186;
    public static final double COLLAPSE = 0.95;
    private static final double SUCK_RANGE = 20.0;
    @Nullable
    private FakePlayer fakePlayer;

    public GapingVoidEntity(Level level) {
        this((EntityType<GapingVoidEntity>)((EntityType)AvaritiaModContent.GAPING_VOID_ENTITY_TYPE.get()), level);
    }

    public GapingVoidEntity(EntityType<GapingVoidEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        int age = this.getAge();
        if (age >= 186) {
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, false, Explosion.BlockInteraction.DESTROY);
            this.m_146870_();
            return;
        }
        if (age == 0) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AvaritiaModContent.GAPING_VOID_SOUND.get(), SoundSource.HOSTILE, 8.0f, 1.0f, true);
        }
        this.setAge(age + 1);
        if (this.f_19853_.f_46443_) {
            return;
        }
        FakePlayer fakePlayer = this.getFakePlayer();
        if (fakePlayer == null) {
            this.m_146870_();
            return;
        }
        Vector3 pos = Vector3.fromEntity((Entity)this);
        double voidScale = GapingVoidEntity.getVoidScale(age);
        double particlespeed = 4.5;
        double size = voidScale * 0.5 - 0.2;
        for (int i = 0; i < 50; ++i) {
            Vector3 particlePos = new Vector3(0.0, 0.0, size);
            particlePos.rotate((double)(this.f_19796_.nextFloat() * 180.0f), new Vector3(0.0, 1.0, 0.0));
            particlePos.rotate((double)(this.f_19796_.nextFloat() * 360.0f), new Vector3(1.0, 0.0, 0.0));
            Vector3 velocity = particlePos.copy().normalize();
            velocity.multiply(particlespeed);
            particlePos.add(pos);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, particlePos.x, particlePos.y, particlePos.z, velocity.x, velocity.y, velocity.z);
        }
        double radius = voidScale * 0.5;
        Cuboid6 cuboid = new Cuboid6().add(pos);
        cuboid.expand(20.0);
        List entities = this.f_19853_.m_6443_(Entity.class, cuboid.aabb(), this::shouldSuck);
        for (Entity ent : entities) {
            if (ent == this) continue;
            Vector3 diff = pos.copy().subtract(Vector3.fromEntity((Entity)ent));
            double len = diff.mag();
            double lenn = len / 20.0;
            if (!(len <= 20.0)) continue;
            double strength = (1.0 - lenn) * (1.0 - lenn);
            double power = 0.075 * radius;
            ent.m_20256_(diff.divide(len).multiply(strength).multiply(power).vec3());
        }
        double attackRange = radius * 0.95;
        cuboid = new Cuboid6().add(pos);
        cuboid.expand(attackRange);
        List entitiesToAttack = this.f_19853_.m_6443_(LivingEntity.class, cuboid.aabb(), this::shouldAttack);
        for (Entity toAttack : entitiesToAttack) {
            Vector3 diff;
            double len;
            if (toAttack == this || !((len = (diff = pos.copy().subtract(Vector3.fromEntity((Entity)toAttack))).mag()) <= attackRange)) continue;
            toAttack.m_6469_(DamageSource.f_19317_, 3.0f);
        }
        attackRange += 2.0;
        fakePlayer.m_146884_(this.m_20182_());
        if (age % 10 == 0) {
            Vector3 posFloor = pos.copy().floor();
            int blockrange = (int)Math.round(attackRange);
            for (int y = -blockrange; y <= blockrange; ++y) {
                for (int z = -blockrange; z <= blockrange; ++z) {
                    for (int x = -blockrange; x <= blockrange; ++x) {
                        FluidState fluid;
                        Vector3 pos2 = new Vector3((double)x, (double)y, (double)z);
                        Vector3 rPos = posFloor.copy().add(pos2);
                        BlockPos blockPos = rPos.pos();
                        if (this.f_19853_.m_151570_(blockPos)) continue;
                        BlockState state = this.f_19853_.m_8055_(blockPos);
                        double dist = pos2.mag();
                        if (dist <= attackRange && !state.m_60795_() && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)fakePlayer, (BlockPos)blockPos, (BlockState)state)) {
                            Explosion explosion = new Explosion(this.f_19853_, (Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f, List.of(blockPos));
                            float resist = state.m_60734_().getExplosionResistance(state, (BlockGetter)this.f_19853_, blockPos, explosion);
                            if ((double)resist <= 10.0) {
                                if (state.canDropFromExplosion((BlockGetter)this.f_19853_, blockPos, explosion)) {
                                    BlockEntity be = state.m_155947_() ? this.f_19853_.m_7702_(blockPos) : null;
                                    LootContext.Builder lootContext = new LootContext.Builder((ServerLevel)this.f_19853_).m_78977_(this.f_19853_.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)be).m_78984_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(10.0f));
                                    for (ItemStack drop : state.m_60724_(lootContext)) {
                                        ItemUtils.dropItem((Level)this.f_19853_, (BlockPos)blockPos, (ItemStack)drop);
                                    }
                                }
                                this.f_19853_.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                            }
                        }
                        if ((fluid = this.f_19853_.m_6425_(blockPos)).m_76178_()) continue;
                        this.f_19853_.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
        }
    }

    private boolean shouldSuck(Entity entity) {
        if (entity instanceof GapingVoidEntity) {
            return false;
        }
        if (entity instanceof EndestPearlEntity) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_150110_().f_35937_ || !player.m_150110_().f_35935_;
        }
        return true;
    }

    private boolean shouldAttack(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_150110_().f_35937_;
        }
        return true;
    }

    public static double getVoidScale(double age) {
        double life = age / 186.0;
        double curve = life < 0.95 ? 0.005 + GapingVoidEntity.ease(1.0 - (0.95 - life) / 0.95) * 0.995 : GapingVoidEntity.ease(1.0 - (life - 0.95) / 0.050000000000000044);
        return 10.0 * curve;
    }

    private static double ease(double in) {
        double t = in - 1.0;
        return Math.sqrt(1.0 - t * t);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(AGE, (Object)0);
    }

    @Nullable
    private FakePlayer getFakePlayer() {
        Level level;
        if (this.fakePlayer == null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.fakePlayer = FakePlayerFactory.get((ServerLevel)level2, (GameProfile)Avaritia.FAKE_PLAYER_PROFILE);
        }
        return this.fakePlayer;
    }

    protected void m_7378_(CompoundTag tag) {
        this.setAge(tag.m_128451_("age"));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("age", this.getAge());
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(AGE, (Object)age);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }
}

